'use strict';

var Decoder = require('../../').Decoder;
var Net = require('net');
var ProtoBuf = require('protocol-buffers/require');

var messages = ProtoBuf(__dirname + '/message.proto');
var decoder = new Decoder(messages.Message);
decoder.on('data', function(data) {
  console.log(data);
});

var server = Net.createServer(function(socket) {
  socket.on('data', function(data) {
    decoder.write(data);
  });
});

server.listen(8001, 'localhost');
