'use strict';

var Encoder = require('../').Encoder;
var ProtoBuf = require('protocol-buffers/require');
var Tap = require('tap');

var messages = ProtoBuf(__dirname + '/message.proto');
var encoder = new Encoder(messages.Message);

Tap.test('write message', function(t) {
  var message = {
    name: 'Hello',
    value: 'world'
  };

  encoder.once('data', function(data) {
    var expected = messages.Message.encode(message);
    t.equal(data.readUInt32BE(0), expected.length);
    t.same(data.slice(4), expected);
    t.end();
  });

  encoder.write(message);
});
